local curStage = GAMESTATE:GetCurrentStage()
local playMode = GAMESTATE:GetPlayMode()
if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
	curStage = playMode;
end;

local t = Def.ActorFrame {};
	
t[#t+1] = Def.ActorFrame {
    InitCommand=cmd(y,SCREEN_TOP);
	LoadActor("_pinkbg") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
		StartTransitioningCommand=cmd(smooth,0.3;diffusealpha,0;zoom,2.0);
	};
};

t[#t+1] = Def.Sprite {
	  BeginCommand=function(self)
		local sPath = THEME:GetPathG("Common","Fallback Banner"); -- use variable so we always have a fallback
		if GAMESTATE:GetCurrentSong() then
		  -- If you got here, you should be golden, if not, oh well
		  sPath = GAMESTATE:GetCurrentSong():GetBannerPath()
		else
		  return
		end
		-- 
		self:LoadBanner(sPath);
	  end;
	  InitCommand=cmd(x,SCREEN_CENTER_X-170;y,SCREEN_CENTER_Y;cropto,256,80;shadowlength,1;);
	  OnCommand=cmd(zoom,0.75;sleep,0.5;smooth,0.5;diffusealpha,0;addx,-90;zoom,0.5);
	  OffCommand=cmd(;);
};

t[#t+1] = Def.ActorFrame {
	  InitCommand=cmd(x,SCREEN_CENTER_X+107;y,SCREEN_CENTER_Y+66);
		LoadFont("Common Normal") .. {
			Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayFullTitle();
			InitCommand=cmd(strokecolor,Color("Outline");y,-20;maxwidth,300);
			OnCommand=cmd(sleep,0.5;smooth,0.5;diffusealpha,0;addx,50);
		};
		LoadFont("Common Normal") .. {
			Text=GAMESTATE:IsCourseMode() and ToEnumShortString( GAMESTATE:GetCurrentCourse():GetCourseType() ) or GAMESTATE:GetCurrentSong():GetDisplayArtist();
			InitCommand=cmd(strokecolor,Color("Outline");zoom,0.75);
			OnCommand=cmd(sleep,0.5;smooth,0.5;diffusealpha,0;addx,50);
		};
};
	
t[#t+1] = Def.ActorFrame {
    InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X+134;y,SCREEN_CENTER_Y-20;);
	LoadActor(THEME:GetPathG("ScreenStageInformation", "stage " .. ToEnumShortString(curStage) ) ) .. {
			OnCommand=cmd(sleep,0.5;smooth,0.5;diffusealpha,0;addx,90;zoom,0.5);
		};
};	

return t